<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;
use Illuminate\Contracts\Container\BindingResolutionException;
use InvalidArgumentException;
use Throwable;

class BulkMoveToTopPriorityOrder extends PriorityOrder
{
    /**
     * BulkMoveToTopPriorityOrder constructor.
     *
     *
     * @throws BindingResolutionException
     */
    public function __construct(array $options)
    {
        parent::__construct($options);

        if (empty($this->options) || ! isset($this->options['ids'])) {
            throw new InvalidArgumentException('ids option is required.');
        }
    }

    /**
     * {@inheritDoc}
     *
     * @throws Throwable
     */
    public function process()
    {
        // We sequentially move the queues to top, bottom elements first
        $ids = array_reverse($this->options['ids']);

        foreach ($ids as $id) {
            $queue = $this->queues->findById($id);
            PriorityOrderFactory::make(BackorderQueue::REORDER_TYPE_MOVE_TO_TOP, $queue)
                ->process();
        }

        $this->refreshCoverages();
    }
}
