<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;
use Illuminate\Contracts\Container\BindingResolutionException;
use InvalidArgumentException;
use Throwable;

class BulkMoveToBottomPriorityOrder extends PriorityOrder
{
    /**
     * BulkMoveToTopPriorityOrder constructor.
     *
     *
     * @throws BindingResolutionException
     */
    public function __construct(array $options)
    {
        parent::__construct($options);

        if (empty($this->options) || ! isset($this->options['ids'])) {
            throw new InvalidArgumentException('ids option is required.');
        }
    }

    /**
     * {@inheritDoc}
     *
     * @throws Throwable
     */
    public function process()
    {
        // We sequentially move the queues to bottom
        foreach ($this->options['ids'] as $id) {
            $queue = $this->queues->findById($id);
            PriorityOrderFactory::make(BackorderQueue::REORDER_TYPE_MOVE_TO_BOTTOM, $queue)
                ->process();
        }

        $this->refreshCoverages();
    }
}
