<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\SalesOrderLineData;
use App\Data\UpdateSalesOrderData;
use App\Models\Product;
use Closure;
use Exception;
use Illuminate\Database\Eloquent\Collection;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class LoadProductsIntoSalesOrderLines
{
    /**
     * @throws Exception
     */
    public function handle(UpdateSalesOrderData $data, Closure $next)
    {
        if($data->payload->sales_order_lines instanceof Optional) {
            return $next($data);
        }

        $products = $this->getProductsFromLines($data->payload->sales_order_lines);

        $data->payload->sales_order_lines = $data->payload->sales_order_lines->map(function (SalesOrderLineData $line) use ($products) {
            if ($line->product_id !== null && !$line->product_id instanceof Optional) {
                $line->product = $products->firstWhere('id', $line->product_id);
            }
            return $line;
        });

        return $next($data);
    }

    /**
     * @param  DataCollection  $salesOrderLines
     * @return Collection
     */
    private function getProductsFromLines(DataCollection $salesOrderLines): Collection
    {
        $withLines = $salesOrderLines
            ->filter(fn(SalesOrderLineData $line) => $line->product_id !== null && !$line->product_id instanceof Optional);

        $productIds = $withLines->toCollection()
            ->map(fn(SalesOrderLineData $line) => $line->product_id)
            ->values();

        return Product::query()
            ->whereIn('id', $productIds)
            ->get();
    }
}