<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\SalesOrderLineData;
use App\Data\UpdateSalesOrderData;
use App\Models\Product;
use Closure;
use Exception;
use Spatie\LaravelData\Optional;

class FulfilledOnCancelledSalesOrderLineHandler
{
    /**
     * @throws Exception
     */
    public function handle(UpdateSalesOrderData $data, Closure $next)
    {
        if ($data->payload->sales_order_lines instanceof Optional) {
            return $next($data);
        }

        $linesFulfilledOnCancelledLine = $data->payload->sales_order_lines
            ->reject(fn(SalesOrderLineData $line) => $line->is_fulfilled_on_cancelled_line instanceof Optional)
            ->filter(fn(SalesOrderLineData $line) => $line->is_fulfilled_on_cancelled_line);
        customlog('SKU-6214', $data->salesOrder->sales_order_number.': lines fulfilled on canceled line', $linesFulfilledOnCancelledLine->toArray());
        $productIdsFulfilledOnCancelledLine = $linesFulfilledOnCancelledLine
            ->toCollection()
            ->pluck('product_id');

        if ($productIdsFulfilledOnCancelledLine->isEmpty()) {
            return $next($data);
        }

        $products = Product::whereIn('id', $productIdsFulfilledOnCancelledLine)->get();
        $csvSkus = $products->pluck('sku')->implode(',');

        $data = app(AddSalesOrderNote::class)->handle($data, "The following SKU's were fulfilled on a cancelled line: {$csvSkus}");
        $data = app(AddSalesOrderTag::class)->handle($data, 'fulfilled-on-cancelled-line');

        return $next($data);
    }
}