<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\UpdateSalesOrderData;
use App\Repositories\AddressRepository;
use Closure;
use Spatie\LaravelData\Optional;
use Throwable;

class FindAddressesForSalesOrder
{
    public function __construct(private readonly AddressRepository $addresses)
    {}

    /**
     * @throws Throwable
     */
    public function handle(UpdateSalesOrderData $data, Closure $next)
    {
        if (!$data->payload->shipping_address instanceof Optional && $data->payload->shipping_address) {
            $address = $this->addresses->findOrCreate($data->payload->shipping_address);
            if ($address->id != $data->salesOrder->shipping_address_id) {
                $data->payload->shouldDeleteFulfillments = true;
                $data->payload->deleteFulfillmentsReason = 'Shipping address changed';
                $data->payload->shippingAddressChanged = true;
            }
            $data->payload->shipping_address_id = $address->id;
        }
        if (!$data->payload->billing_address instanceof Optional && $data->payload->billing_address) {
            $data->payload->billing_address_id = $this->addresses->findOrCreate($data->payload->billing_address)->id;
        }

        return $next($data);
    }
}