<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\SalesOrderLineData;
use App\Data\UpdateSalesOrderData;
use App\Exceptions\SalesOrder\LineFulfilledAtWarehouseException;
use Closure;
use Spatie\LaravelData\Optional;

class CheckIfTryingToChangeWarehouseOnFulfilledSalesOrderLine
{
    /**
     * @throws LineFulfilledAtWarehouseException
     */
    public function handle(UpdateSalesOrderData $data, Closure $next)
    {
        if ($data->payload->sales_order_lines instanceof Optional) {
            return $next($data);
        }

        if ($fulfilledSalesOrderLine = $data->payload->sales_order_lines->filter(function (SalesOrderLineData $line) {
            if (
                $line->warehouse_id instanceof Optional ||
                $line->salesOrderLine instanceof Optional ||
                $line->warehouse_id == $line->salesOrderLine->warehouse_id
            ) {
                return false;
            }

            return $line->salesOrderLine->salesOrderFulfillmentLines->isNotEmpty();
        })?->first()) {
            throw new LineFulfilledAtWarehouseException($fulfilledSalesOrderLine->salesOrderLine->product, "Cannot change warehouse for sku: {$fulfilledSalesOrderLine->salesOrderLine->product->sku}, line has fulfillments.");
        }

        return $next($data);
    }
}