<?php

namespace App\Services\SalesOrder\Actions;

use App\Data\UpdateSalesOrderData;
use App\Data\NoteData;
use Spatie\LaravelData\Optional;

class AddSalesOrderNote
{
    public function handle(UpdateSalesOrderData $data, string $note): UpdateSalesOrderData
    {
        if ($data->payload->notes instanceof Optional) {
            $data->payload->notes = NoteData::collection([
                NoteData::from([
                    'note' => $note,
                ])
            ]);
        } else {
            $data->payload->notes[] = NoteData::from([
                'note' => $note,
            ]);
        }

        return $data;
    }
}