<?php

namespace App\Services\PurchaseOrder;

use App\Models\PurchaseOrder;
use App\Response;
use Illuminate\Http\Request;

class BulkApprovePurchaseOrderService
{
    protected $request;

    private $response = [];

    private $errorsCount = 0;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function approve(): array
    {
        set_time_limit(0);

        $this->getBuilder()->each(function (PurchaseOrder $purchaseOrder) {
            // already approved
            if (! $purchaseOrder->isDraft()) {
                $this->response[$purchaseOrder->id] = __('messages.purchase_order.already_approved', ['id' => $purchaseOrder->purchase_order_number]);

                return; // continue
            }

            if (is_array($res = $purchaseOrder->approve())) {
                $this->response[$purchaseOrder->id][] = Response::getError(...$res);
                $this->errorsCount++;
            } else {
                $this->response[$purchaseOrder->id] = __('messages.purchase_order.approved', ['id' => $purchaseOrder->purchase_order_number]);
            }
        });

        return $this->response;
    }

    public function getErrorsCount(): int
    {
        return $this->errorsCount;
    }

    private function getBuilder()
    {
        $builder = PurchaseOrder::with([]);
        if ($this->request->has('ids')) {
            $builder->whereIn('id', array_unique($this->request->input('ids', [])));
        } else {
            // use advanced filter
            $builder->filter($this->request)->archived($this->request->input('archived', 0));
        }

        return $builder;
    }
}
