<?php

namespace App\Services\Product;

use App\Models\BackorderQueue;
use App\Models\FifoLayer;

class ReleaseFBABackorderQueues extends ReleaseBackorderQueues
{
    public function execute(FifoLayer $fifoLayer, ?string $linkType = null, ?int $linkId = null, ?int $quantity = null)
    {
        $remainingQuantity = $quantity ?? $fifoLayer->available_quantity;

        if ($remainingQuantity <= 0) {
            return;
        }

        // Get backorder queues and try to clear those that are satisfiable by the fifo layer
        $unreleasedBackorders = $this->backorderQueues->getActiveQueuesForProduct(
            $this->product->id,
            $fifoLayer->warehouse_id
        );

        //    dd($unreleasedBackorders->toArray());

        /** @var BackorderQueue $backorderQueue */
        foreach ($unreleasedBackorders as $backorderQueue) {
            if ($backorderQueue->unreleased_quantity > $remainingQuantity) {
                // The fifo layer cannot fully satisfy the backorder queue.
                // We only satisfy the quantity available and charge the fifo
                // layer. The remaining quantity will be satisfied in the future.
                // Since the backorder layer isn't fully satisfied, we will
                // create a new inventory movements with satisfied quantity and
                // reduce quantity from backorder inventory movements
                $neededQuantity = $remainingQuantity;
                $remainingQuantity = 0;
            } else {
                // Quantity can satisfy entire backorder layer.
                // We satisfy it and charge to the fifo layer.
                // Also, since the entire backorder layer is satisfied,
                // we link its inventory movements to the fifo layer.
                $neededQuantity = $backorderQueue->unreleased_quantity;
                $remainingQuantity -= $neededQuantity;
            }

            // Release the needed quantity on the backorder queue.
            $backorderQueue->addFBARelease(
                $linkId ?? $fifoLayer->link_id,
                $linkType ?? $fifoLayer->link_type,
                $neededQuantity,
                $fifoLayer
            );

            if ($remainingQuantity <= 0) {
                break;
            }
        }
    }
}
