<?php

namespace App\Services\InventoryManagement;

use App\Models\InventoryMovement;
use Carbon\Carbon;
use Illuminate\Contracts\Support\Arrayable;

/**
 * Interface NegativeInventoryEvent
 */
interface NegativeInventoryEvent extends InventoryEvent
{
    /**
     * Creates the movements needed for the negative event.
     * Should update quantity for layers that already exist.
     */
    public function createInventoryMovementsForLayers(array $layers, ?Carbon $dateOverride = null): void;

    /**
     * Gets the active inventory movements for the reduction in
     * inventory.
     */
    public function getReductionActiveMovements(): Arrayable;

    /**
     * Clears the inventory movements for the negative event
     */
    public function clearMovements(): void;

    /**
     * Reduces the quantity of the inventory movements by
     * the given quantity. The representing movement is the
     * inventory movement that directly affects inventory
     * (-ve active movement).
     */
    public function reduceQtyWithSiblings(int $quantity, InventoryMovement $representingMovement): void;

    /**
     * If the FIFO cost was updated, this method will be called to trigger necessary updates down the line such as
     * updating updated_at timestamps so that an accounting transaction recalculation will be triggered
     */
    public function refreshFromFifoCostUpdate(float $amount = 0): void;
}
