<?php

namespace App\Services\InventoryManagement;

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;

class InventoryUsageCollection extends Collection
{
    public function addInventoryUsages(InventoryUsageDto|array $inventoryUsages): void
    {
        if (! is_array($inventoryUsages)) {
            $inventoryUsages = Arr::wrap($inventoryUsages);
        }

        foreach ($inventoryUsages as $inventoryUsageDto) {
            $this->add($inventoryUsageDto->toArray());
        }
    }
}
