<?php

namespace App\Services\InventoryManagement;

use App\Models\FifoLayer;
use Exception;

class InvalidFifoLayerCacheException extends Exception
{
    public function __construct(FifoLayer $fifoLayer, int $movementsUsage)
    {
        $this->message = "Fifo Layer: {$fifoLayer->id} has fulfilled quantity: {$fifoLayer->fulfilled_quantity} but quantity used by movements is: $movementsUsage.";
    }
}
