<?php

namespace App\Services\InventoryAdjustment;

use App\Http\Requests\StoreInventoryAdjustment;
use App\Models\InventoryAdjustment;
use App\Models\Product;

class SetInventoryAdjustmentService extends InventoryAdjustmentService
{
    public function execute(?InventoryAdjustment $inventoryAdjustment = null): ?InventoryAdjustment
    {
        $newQuantity = $this->getQuantity();

        $product = Product::with(['totalQuantity'])->findOrFail($this->inventoryAdjustmentRequest->input('product_id'));

        $warehouseInventoryCount = $product->inventoryMovements()
            ->where('warehouse_id', $this->inventoryAdjustmentRequest->input('warehouse_id'))
            ->sum('quantity');

        $diffQuantity = $newQuantity - $warehouseInventoryCount;

        $this->inventoryAdjustmentRequest->mergeToData(['quantity' => $diffQuantity]);

        if ($diffQuantity != 0) {
            if ($diffQuantity > 0) {
                $this->inventoryAdjustmentRequest->mergeToData(['adjustment_type' => StoreInventoryAdjustment::ADJUSTMENT_TYPE_INCREASE]);

                return PositiveInventoryAdjustmentService::make($this->inventoryAdjustmentRequest)->execute();
            } else {
                $this->inventoryAdjustmentRequest->mergeToData(['adjustment_type' => StoreInventoryAdjustment::ADJUSTMENT_TYPE_DECREASE]);

                return NegativeInventoryAdjustmentService::make($this->inventoryAdjustmentRequest)->execute();
            }
        }

        return null;
    }
}
