<?php

namespace App\Services\Accounting\Actions\FinancialDocuments;

use App\Abstractions\FinancialDocumentInterface;
use App\Data\AccountingTransactionData;
use App\Data\AccountingTransactionLineData;
use App\Enums\AccountingTransactionTypeEnum;
use App\Models\PurchaseInvoice;
use App\Models\PurchaseInvoiceLine;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderLine;
use Illuminate\Support\Collection;
use Throwable;

class BuildAccountingTransactionDataFromPurchaseInvoice
{
    public function __construct(
        private readonly PurchaseInvoice|FinancialDocumentInterface $purchaseInvoice,
    ) {}

    /**
     * @throws Throwable
     */
    public function handle(): AccountingTransactionData
    {
        // TODO: Old code skipped if parent accounting transaction does not exist... not sure the implications of not skipping.
        $purchaseInvoice = $this->purchaseInvoice;

        $linesCollection = $this->getLines();
        return AccountingTransactionData::from([
            'type' => AccountingTransactionTypeEnum::PURCHASE_ORDER_INVOICE,
            'link_id' => $purchaseInvoice->id,
            'link_type' => PurchaseInvoice::class,
            'name' => $purchaseInvoice->supplier->name,
            'email' => $purchaseInvoice->supplier->email,
            'transaction_date' => $purchaseInvoice->purchase_invoice_date,
            'reference' => $purchaseInvoice->purchaseOrder->purchase_order_number . ': ' . $purchaseInvoice->supplier_invoice_number,
            'is_tax_included' => $purchaseInvoice->purchaseOrder->is_tax_included ?? false,
            //'currency_code' => $purchaseInvoice->purchaseOrder->currency->code,
            //'currency_rate' => $purchaseInvoice->purchaseOrder->currency_rate,
            'currency_code' => $purchaseInvoice->purchaseOrder->currencyTenantSnapshot->code,
            'currency_rate' => 1,
            'is_batchable' => false,
            'parent_id' => $purchaseInvoice->getParentAccountingTransaction()?->id,
            'accounting_transaction_lines' => AccountingTransactionLineData::collection($linesCollection),
            'total' => $linesCollection->sum(fn ($line) => $line->quantity * $line->amount),
        ]);
    }

    private function getLines(): Collection
    {
        return $this->purchaseInvoice->purchaseInvoiceLines->map(function (PurchaseInvoiceLine $line)
        {
            return (new BuildAccountingTransactionLineDataFromPurchaseInvoiceLine($line))->handle();
        });
    }
}