<?php

namespace App\Services\Accounting\Actions;

use App\Models\AccountingTransaction;
use App\Repositories\Accounting\AccountingTransactionRepository;
use Closure;
use Illuminate\Support\Collection;

class BuildAccountingTransactionsForUpdate
{
    public function __construct(private readonly AccountingTransactionRepository $transactions)
    {
    }

    public function handle(Collection $transactionCollection, int $limit, int $offset, Closure $next)
    {
        if ($transactionCollection->isEmpty()) {
            $transactionCollection = $this->transactions->getTransactionsNeedingUpdate($limit, $offset);
        }

        $transactionCollection = $transactionCollection
            ->reject(fn(AccountingTransaction $transaction) => $transaction->is_locked)
            ->map(fn(AccountingTransaction $transaction) => $transaction->link->getAccountingTransactionData());

        return $next($transactionCollection);
    }
}
