<?php

namespace App\Services\Accounting\Actions;

use App\Enums\AccountingTransactionTypeEnum;
use App\Helpers;
use App\Models\SalesOrder;
use App\Models\Setting;
use Closure;
use Exception;
use Illuminate\Support\Collection;

class BuildAccountingTransactionsForCreate
{
    /**
     * @throws Exception
     */
    public function handle(Collection $transactionCollection, int $limit, int $offset, Closure $next)
    {
        $startDate = Helpers::setting(Setting::KEY_ACCOUNTING_START_DATE);
        $lockDate = Helpers::setting(Setting::KEY_ACCOUNTING_LOCK_DATE);
        foreach (AccountingTransactionTypeEnum::getCasesWithFinancialDocuments() as $type)
        {
            $financialDocumentClass = $type->getFinancialDocumentClass();
            $financialDocumentsNeedingTransactionQuery = app($financialDocumentClass)->query()
                ->whereDoesntHave('accountingTransaction')
                ->accountingReady()
                ->limit($limit)
                ->offset($offset)
                ->orderBy('id', 'asc')
                ->accountingReady();

            if ($financialDocumentClass == SalesOrder::class) {
                $financialDocumentsNeedingTransactionQuery->with('salesChannel.integrationInstance');
            }

            if ($startDate) {
                $financialDocumentsNeedingTransactionQuery->where(app($financialDocumentClass)->getAccountingDateFieldName(), '>=', $startDate);
            }

            if ($lockDate) {
                $financialDocumentsNeedingTransactionQuery->whereDate(app($financialDocumentClass)->getAccountingDateFieldName(), '>', $lockDate);
            }

            $financialDocumentsNeedingTransaction = $financialDocumentsNeedingTransactionQuery->get();

            $transactionCollection->push($financialDocumentsNeedingTransaction->map(
                function ($financialDocument) {
                    return $financialDocument->getAccountingTransactionData();
                }
            ));
        }

        return $next($transactionCollection);
    }
}
