<?php
/**
 * Created by Inspiring IT Solutions.
 * User: a.elsaidy<ahmad.elsaidy@hotmail.com>
 * Date: 4/3/2019
 * Time: 5:01 PM
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at.
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace App\SDKs\WalmartSDK;

use DOMAttr;
use DOMCdataSection;
use DOMDocument;
use DOMElement;
use DOMNamedNodeMap;
use DOMText;

class XMLFormatter
{
    protected $document;

    public function __construct(string $xml)
    {
        $this->document = new DOMDocument();
        $this->document->loadXML($xml);
    }

    public static function convert(string $xml): array
    {
        $converter = new static($xml);

        return $converter->toArray();
    }

    protected function convertAttributes(DOMNamedNodeMap $nodeMap): ?array
    {
        if ($nodeMap->length === 0) {
            return null;
        }
        $result = [];
        /** @var DOMAttr $item */
        foreach ($nodeMap as $item) {
            $result[$item->name] = $item->value;
        }

        return ['_attributes' => $result];
    }

    protected function isHomogenous(array $arr)
    {
        $firstValue = current($arr);
        foreach ($arr as $val) {
            if ($firstValue !== $val) {
                return false;
            }
        }

        return true;
    }

    protected function convertDomElement(DOMElement $element)
    {
        $sameNames = false;
        $result = $this->convertAttributes($element->attributes);
        if ($element->childNodes->length > 1) {
            $childNodeNames = [];
            foreach ($element->childNodes as $key => $node) {
                $childNodeNames[] = $node->nodeName;
            }
            $sameNames = $this->isHomogenous($childNodeNames);
        }
        foreach ($element->childNodes as $key => $node) {
            if ($node instanceof DOMCdataSection) {
                $result['_cdata'] = $node->data;

                continue;
            }
            if ($node instanceof DOMText) {
                $result = $node->textContent;

                continue;
            }
            if ($node instanceof DOMElement) {
                if ($sameNames) {
                    $result[$node->nodeName][$key] = $this->convertDomElement($node);
                } else {
                    $result[$node->nodeName] = $this->convertDomElement($node);
                }

                continue;
            }
        }

        return $result;
    }

    public function toArray(): array
    {
        $result = [];
        if ($this->document->hasChildNodes()) {
            $children = $this->document->childNodes;
            foreach ($children as $child) {
                $result[$child->nodeName] = $this->convertDomElement($child);
            }
        }

        return $result;
    }
}
