<?php

namespace App\SDKs\Starshipit\Model;

/**
 * Class Order.
 *
 * @property int $order_id The unique numeric identifier for the order (For update only)
 * @property ?string $order_date The date when the order was created in UTC
 * @property string $order_number The identifier of the order pulled from source e-Commerce platform (max length: 50)
 * @property string $reference Customer's reference (max length: 50)
 * @property ?string $shipping_method Delivery method name (max length: 100)
 * @property ?string $shipping_description Delivery method description (max length: 100)
 * @property ?bool $signature_required Determine whether signature is needed on delivery
 * @property ?bool $return_order If true, only the return label will be generated
 * @property ?string $currency Currency code for the order value (max length: 3) e.g. AUD
 * @property ?SenderDetails $sender_details Sender address and contact details
 * @property DestinationDetails $destination Shipping address and contact details
 * @property ?OrderItem[] $items Item list containing the order item details
 * @property ?OrderPackage[] $packages Package list containing the parcel details
 */
class Order extends Model
{
    use Validatable;

    /**
     * {@inheritDoc}
     */
    public function rules(): array
    {
        return [
            'order_number' => 'required',
            'signature_required' => 'nullable|boolean',
            'return_order' => 'nullable|boolean',
            'sender_details' => 'nullable',
            'sender_details.name' => 'required',
            'sender_details.street' => 'required',
            'sender_details.suburb' => 'required',
            'sender_details.country' => 'required',
            'destination.name' => 'required',
            'destination.street' => 'required',
            'destination.suburb' => 'required',
            'destination.country' => 'required',
            'items.*.quantity' => 'nullable|numeric',
            'items.*.weight' => 'nullable|numeric',
            'items.*.value' => 'nullable|numeric',
            'packages.*.weight' => 'nullable|numeric',
            'packages.*.height' => 'nullable|numeric',
            'packages.*.width' => 'nullable|numeric',
            'packages.*.length' => 'nullable|numeric',
        ];
    }

    /**
     * {@inheritDoc}
     */
    public function customAttributes(): array
    {
        return [
            'sender_details.name' => 'Store Name',
            'sender_details.street' => 'Warehouse Address Line 1',
            'sender_details.suburb' => 'Warehouse Address City',
            'sender_details.country' => 'Warehouse Address Country',
            'destination.name' => 'Shipping details are missing, review Shipping Address Name',
            'destination.street' => 'Shipping details are missing, review Shipping Address Line 1',
            'destination.suburb' => 'Shipping details are missing, review Shipping Address City',
            'destination.country' => 'Shipping details are missing, review Shipping Address Country',
        ];
    }
}
