<?php

namespace App\SDKs\Starshipit\Model;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;

abstract class Model implements Arrayable, Jsonable
{
    public function toArray()
    {
        return static::propertiesToArray((array) $this);
    }

    public function toJson($options = 0)
    {
        return json_encode($this->toArray(), $options);
    }

    /**
     * Convert model properties to associated array.
     *
     * @return array
     */
    public static function propertiesToArray($properties)
    {
        $attributes = [];

        foreach ($properties as $key => $value) {
            if ($value instanceof self) {
                $attributes[$key] = $value->toArray();
            } elseif (is_array($value)) { // recursion array.
                $attributes[$key] = static::propertiesToArray($value);
            } else {
                $attributes[$key] = $value;
            }
        }

        return $attributes;
    }
}
