<?php

namespace App\SDKs\ShipStation\Services;

use App\SDKs\ShipStation\Model\ShipStationWebhook;
use App\SDKs\ShipStation\Responses\CreateWebhookResponse;
use App\SDKs\ShipStation\ShipStation;
use App\SDKs\ShipStation\ShipStationException;
use Exception;
use Symfony\Component\HttpFoundation\Request;

class Webhooks extends ShipStation
{
    /**
     * @throws ShipStationException
     * @throws Exception
     */
    public function create(ShipStationWebhook $webhook): CreateWebhookResponse
    {
        return new CreateWebhookResponse(array_merge($webhook->toArray(),
            $this->request('/subscribe', $webhook->toJson(), Request::METHOD_POST)));
    }

    /**
     * Get a List of webhook results.
     *
     * @throws ShipStationException
     * @throws Exception
     */
    public function list(): array
    {
        return $this->request('/', Request::METHOD_GET)['webhooks'];
    }

    /**
     * @throws ShipStationException
     * @throws Exception
     */
    public function delete(int $shipstation_webhook_id): array
    {
        return $this->request('/'.$shipstation_webhook_id, [], Request::METHOD_DELETE);
    }
}
