<?php

namespace App\SDKs\ShipStation\Services;

use App\SDKs\ShipStation\Requests\ListShipmentsRequest;
use App\SDKs\ShipStation\Responses\ListShipmentsResponse;
use App\SDKs\ShipStation\ShipStation;
use App\SDKs\ShipStation\ShipStationException;

class Shipments extends ShipStation
{
    /**
     * Get a List of ShipStation shipments.
     *
     *
     * @throws ShipStationException
     */
    public function getList(?ListShipmentsRequest $listShipmentsRequest = null): ListShipmentsResponse
    {
        $query = $listShipmentsRequest ? $listShipmentsRequest->getQueryParams() : null;

        return new ListShipmentsResponse($this->request($query ? "?{$query}" : ''));
    }
}
