<?php

namespace App\SDKs\ShipStation\Services;

use App\SDKs\ShipStation\Model\ShipStationWebhook;
use App\SDKs\ShipStation\Requests\WebhooksShipmentsRequest;
use App\SDKs\ShipStation\Responses\ListOrdersResponse;
use App\SDKs\ShipStation\Responses\ListShipmentsResponse;
use App\SDKs\ShipStation\ShipStation;
use App\SDKs\ShipStation\ShipStationException;
use Exception;

class ShipStationWebhookResult extends ShipStation
{
    /**
     * Get a List of webhook results.
     *
     *
     * @return ListShipmentsResponse|ListOrdersResponse
     *
     * @throws ShipStationException
     * @throws Exception
     */
    public function getList(ShipStationWebhook $webhook, ?WebhooksShipmentsRequest $webhooksShipmentsRequest = null)
    {
        $query = $webhooksShipmentsRequest?->getQueryParams();

        $request = $this->customRequest($webhook->resource_url.($query ? "&{$query}" : ''));

        switch ($webhook->resource_type) {
            case ShipStationWebhook::TYPE_SHIP_NOTIFY:
                return new ListShipmentsResponse($request);
            case ShipStationWebhook::TYPE_ORDER_NOTIFY:
                return new ListOrdersResponse($request);

            default:
                throw new Exception('Type not exists.');
        }
    }
}
