<?php

namespace App\SDKs\ShipStation\Responses;

use App\SDKs\ShipStation\Model\Shipment;

/**
 * Class ListShipmentsResponse.
 *
 * @property Shipment[] $shipments
 * @property int $pages
 * @property int $page
 */
class ListShipmentsResponse extends Response
{
    public function getShipmentsAttribute()
    {
        $shipments = [];
        foreach ($this->attributes['shipments'] as $shipment) {
            $shipments[] = new Shipment($shipment);
        }

        return $shipments;
    }
}
