<?php

namespace App\SDKs\ShipStation\Responses;

use App\SDKs\ShipStation\Model\Order;

/**
 * Class ListOrdersResponse.
 *
 * @property Order[] $orders
 * @property int $total
 * @property int $page
 * @property int $pages
 */
class ListOrdersResponse extends Response
{
    public function getOrdersAttribute()
    {
        $orders = [];
        foreach ($this->attributes['orders'] as $order) {
            $orders[] = new Order($order);
        }

        return $orders;
    }
}
