<?php

namespace App\SDKs\ShipStation\Responses;

use App\SDKs\ShipStation\Responses\SubDatatypes\BulkOrderResult;

/**
 * Class BulkCreateUpdateOrdersResponse.
 *
 * @property bool $hasErrors
 * @property BulkOrderResult[] $results
 */
class BulkCreateUpdateOrdersResponse extends Response
{
    public function getResultsAttribute()
    {
        $results = [];
        foreach ($this->attributes['results'] as $result) {
            $results[] = new BulkOrderResult($result);
        }

        return $results;
    }
}
