<?php

namespace App\SDKs\ShipStation\Requests;

use App\SDKs\ShipStation\Model\Order;

/**
 * Class ListOrdersRequest.
 *
 * @property string $customerName Returns orders that match the specified name.
 * @property string $itemKeyword Returns orders that contain items that match the specified keyword.
 *  Fields searched are SKU, Description, and Options.
 * @property string $createDateStart
 * @property string $createDateEnd
 * @property string $modifyDateStart
 * @property string $modifyDateEnd
 * @property string $orderDateStart
 * @property string $orderDateEnd
 * @property string $orderNumber Filter by order number, performs a "starts with" search.
 * @property string $orderStatus options: {@see Order::STATUSES
 * @property string $paymentDateStart Returns orders that were paid after the specified date.
 * @property string $paymentDateEnd Returns orders that were paid before the specified date.
 * @property int $storeId Filters orders to a single store. Call List Stores to obtain a list of store Ids.
 * @property string $sortBy options: OrderDate, ModifyDate or CreateDate
 * @property string $sortDir options: ASC or DESC
 * @property int $page Page number.
 * @property int $pageSize Requested page size. Max value is 500.
 */
class ListOrdersRequest extends Request
{
    public static function defaultInstance()
    {
        return new static(['page' => 1, 'pageSize' => 100]);
    }
}
