<?php

namespace App\SDKs\ShipStation\Model\XML;

use App\SDKs\ShipStation\Model\Model;
use DOMDocument;
use DOMNode;

abstract class XML extends Model
{
    /**
     * Convert array of attributes(contains objects and arrays) to XML Dom.
     *
     *
     *
     * @return DOMNode
     */
    public function toXml(?DOMDocument $domDocument = null, ?DOMNode $parentNode = null)
    {
        if (is_null($domDocument)) {
            /* create a dom document and parentNode with encoding utf8 */
            $domDocument = $parentNode = new DOMDocument('1.0', 'utf-8');
        }

        /* parentNode is domDocument if null */
        if (is_null($parentNode)) {
            $parentNode = $domDocument;
        }

        /* add attributes of object to domDocument */
        $attributes = get_object_vars($this);
        unset($attributes['errors']);

        $this->attributesToXML($attributes, $domDocument, $parentNode);

        return $domDocument;
    }

    /**
     * Convert array of attribute(contains objects and arrays) to DOM XML.
     *
     * @param  array  $attributes
     */
    private function attributesToXML($attributes, DOMDocument $domDocument, ?DOMNode $parentNode = null)
    {
        /* parentNode is domDocument if null */
        if (is_null($parentNode)) {
            $parentNode = $domDocument;
        }

        foreach ($attributes as $key => $value) {
            if (is_object($value) && $value instanceof Model) {
                /* get base name of model class */
                $element_name = substr(strrchr(get_class($value), '\\'), 1);

                /* create new node named "base model class ($element_name)" and add to parent node. */
                $element = $domDocument->createElement($element_name);
                $parentNode->appendChild($element);

                /* convert model to xml and add to created node */
                $value->toXml($domDocument, $element);
            } elseif (is_array($value)) { // recursion if array.
                /* create new node named value of "$key" and add to parent node. */
                $element = $domDocument->createElement($key);
                $parentNode->appendChild($element);

                /* recursion then add to created node */
                $this->attributesToXML($value, $domDocument, $element);
            } else {
                $value = is_string($value) ? '<![CDATA['.$value.']]>' : $value;
                $parentNode->appendChild($domDocument->createElement($key, html_entity_decode($value)));
            }
        }
    }

    /**
     * Convert this keys to object.
     */
    protected function keyNamesToObject()
    {
        return [
            'Recipient' => ShipTo::class,
            'Items' => Item::class,
        ];
    }
}
