<?php

namespace App\SDKs\ShipStation\Model\XML;

/**
 * Class Order.
 *
 *
 * @property string $OrderID
 * @property string $OrderNumber
 * @property string $OrderDate
 * @property string $OrderStatus
 * @property string $LastModified
 * @property string $ShippingMethod
 * @property string $PaymentMethod
 * @property float $OrderTotal
 * @property float $TaxAmount
 * @property float $ShippingAmount
 * @property string $CustomerNotes
 * @property string $InternalNotes
 * @property bool $Gift
 * @property string $GiftMessage
 * @property string $CustomField1
 * @property string $CustomField2
 * @property string $CustomField3
 * @property string $RequestedWarehouse
 * @property Customer $Customer
 * @property Items $Items
 */
class Order extends XML
{
    /**
     * Rules of model.
     */
    public function rules(): array
    {
        return [
            'OrderID' => 'required',
            'OrderNumber' => 'required',
            'OrderDate' => 'required|date:m/d/Y H:m',
            'OrderStatus' => 'required',
            'LastModified' => 'required|date:m/d/Y H:m',
            'OrderTotal' => 'required|numeric',
            'TaxAmount' => 'numeric',
            'ShippingAmount' => 'required|numeric',
            'Gift' => 'datatype:boolean',
            'Customer' => 'required|datatype:'.Customer::class,
            'Items' => 'array',
            'Items.*' => 'datatype:'.Item::class,
        ];
    }
}
