<?php

namespace App\SDKs\ShipStation\Model\XML;

/**
 * Class Item.
 *
 *
 * @property string $LineItemID
 * @property string $SKU
 * @property string $Name
 * @property string $ImageUrl
 * @property string $Weight
 * @property string $WeightUnits
 * @property string $Quantity
 * @property string $UnitPrice
 * @property string $Location
 * @property bool $Adjustment
 * @property Options $Options
 */
class Item extends XML
{
    /**
     * Rules of model.
     */
    public function rules(): array
    {
        return [
            'SKU' => 'required',
            'Name' => 'required',
            'Quantity' => 'required|numeric',
            'UnitPrice' => 'required|numeric',
            'Options' => 'datatype:'.Options::class,
        ];
    }
}
