<?php

namespace App\SDKs\ShipStation\Model;

/**
 * Class OrderItem.
 *
 *
 * @property-read int $orderItemId The system generated identifier for the OrderItem. This is a read-only field.
 * @property string $lineItemKey An identifier for the OrderItem in the originating system.
 * @property string $sku
 * @property string $name
 * @property string $imageUrl
 * @property Weight $weight
 * @property int $quantity
 * @property float $unitPrice
 * @property float $taxAmount
 * @property float $shippingAmount
 * @property string $warehouseLocation
 * @property ItemOption $options
 * @property int $productId
 * @property string $fulfillmentSku
 * @property bool $adjustment Indicates that the OrderItem is a non-physical adjustment to the order (e.g. a discount or promotional code)
 * @property string $upc
 * @property-read string $createDate
 * @property-read string $modifyDate
 */
class OrderItem extends Model
{
}
