<?php

namespace App\Rules;

use App\Models\Product;
use Illuminate\Contracts\Validation\ValidationRule;

class StandardProductRule implements ValidationRule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure  $fail
     * @return void
     */

    public function validate(string $attribute, mixed $value, \Closure $fail): void
    {
        $product = Product::find($value);
        if($product && $product->isStandard())
        {
            return;
        }

        $fail(__('messages.product.blemished_original_standard'));
    }
}
