<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class CheckUserPasswordRule implements ValidationRule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the validation error message.
     */
    public function message(): string
    {
        return 'Please check the current password.';
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if ($value) {
            $hashedPassword = auth()->user()->password;

            if (\Hash::check($value, $hashedPassword)) {
                return;
            }
        }

        $fail('Check Password Validation Failed.');
    }
}
