<?php

namespace App\Repositories;

use App\Abstractions\AbstractRepository;
use App\Models\TaxRate;
use Illuminate\Support\Collection;

class TaxRateRepository extends AbstractRepository
{
    public function getAll(): Collection
    {
        return TaxRate::all();
    }

    public function createTaxRateFromNameAndRate(string $name, float $rate): TaxRate
    {
        $taxRate = new TaxRate();
        $taxRate->name = $name;
        $taxRate->rate = $rate;

        $taxRate->save();

        return $taxRate;
    }
}