<?php

namespace App\Repositories\Shipstation;

use App\Models\ShippingProviderWarehouseMapping;
use App\Models\ShipStation\ShipstationWarehouse;
use Illuminate\Database\Eloquent\Collection;

class ShipstationRepository
{

    public function createWarehouseMappings(array $mapping)
    {
        ShippingProviderWarehouseMapping::query()
            ->upsert(
                collect($mapping)->map(function($current){
                    return [
                        'warehouse_id' => $current['warehouse_id'],
                        'provider_id' => $current['shipstation_warehouse_id'],
                        'provider_type' => ShipstationWarehouse::class,
                    ];
                })->toArray(),
                ['warehouse_id', 'provider_type']
            );
    }

    public function getWarehouseMappings(): Collection
    {
        return ShippingProviderWarehouseMapping::with(['warehouse', 'provider'])
            ->where('provider_type', ShipstationWarehouse::class)
            ->get();
    }

    public function deleteWarehouseMappings(array $ids)
    {
        ShippingProviderWarehouseMapping::query()
            ->whereIn('id', $ids)
            ->delete();
    }

    public function getWarehouses()
    {
        return ShipstationWarehouse::query()->get();
    }
}