<?php

namespace App\Repositories\ShippingProviders;

use App\Data\CreateShippingProviderIntegrationInstanceData;
use App\Data\UpdateShippingProviderIntegrationInstanceData;
use App\Models\IntegrationInstance;
use Illuminate\Database\Eloquent\Model;
use Spatie\LaravelData\Optional;

class ShippingProviderRepository
{
    /**
     * @param  string  $providerName
     * @return bool
     */
    public function providerNameExists(string $providerName): bool
    {
        return IntegrationInstance::query()
            ->where('name', $providerName)
            ->exists();
    }

    /**
     * @param  CreateShippingProviderIntegrationInstanceData  $data
     * @return IntegrationInstance|Model
     */
    public function create(CreateShippingProviderIntegrationInstanceData $data): IntegrationInstance|Model
    {
        return IntegrationInstance::query()->create(
            $this->normalizeIntegrationSettings($data->toArray())
        );
    }

    public function update(IntegrationInstance $integrationInstance, UpdateShippingProviderIntegrationInstanceData $data): IntegrationInstance
    {
        $settings = $integrationInstance->integration_settings;
        if(!$data->integration_settings instanceof Optional){
            // Update ony parts of integration settings supplied
            $settings = array_merge(
                $settings,
                $data->integration_settings->toArray()
            );
        }

        $integrationInstance->update(
            $this->normalizeIntegrationSettings(array_merge(
                $data->toArray(),
                [
                    'integration_settings' => $settings
                ]
            ))
        );

        return $integrationInstance;
    }


    private function normalizeIntegrationSettings(array $payload): array
    {
        $settings = $payload['integration_settings'];
        if(!empty($settings['linked_warehouse'])){
            $settings['linked_warehouse_id'] = $settings['linked_warehouse']['id'];
            unset($settings['linked_warehouse']);
        }

        $payload['integration_settings'] = $settings;

        return $payload;
    }
}