<?php

namespace App\Repositories;

use App\Models\ShippingMethod;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Illuminate\Database\Eloquent\Model;

class ShippingMethodRepository
{
    public function getMethodsFromCarrierId(int $shippingCarrierId): EloquentCollection
    {
        return ShippingMethod::query()
            ->where('shipping_carrier_id', $shippingCarrierId)
            ->get();
    }

    public function getCarrierFromCarrierIdAndName(int $carrierId, string $name): ShippingMethod|Model
    {
        return ShippingMethod::query()
            ->where('shipping_carrier_id', $carrierId)
            ->where('name', $name)
            ->first();
    }

    public function save(array $data): void
    {
        ShippingMethod::query()->upsert($data, ['carrier_id', 'name']);
    }
}
