<?php

namespace App\Repositories;

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;

/**
 * Class WarehouseRepository.
 */
class SettingRepository
{
    public static function getInventoryStartDate(string $timezone = 'UTC'): Carbon
    {
        return Carbon::parse(SettingRepository::getSettingByKey(Setting::KEY_INVENTORY_START_DATE), $timezone);
    }

    public static function getSettingByKey(string $key): mixed
    {
        return Helpers::setting($key);
    }

    public function addWarehousePriority(int $warehouseId): void
    {
        // Add warehouse to warehouse priority
        /** @var Setting $setting */
        $setting = Setting::query()->where('key', Setting::KEY_WAREHOUSE_PRIORITY)->firstOrFail();
        $setting->value = json_encode(array_merge(json_decode($setting->value), [$warehouseId]));
        $setting->save();
    }

    public function getWarehousesIdsByPriority(): array
    {
        return json_decode(SettingRepository::getSettingByKey(Setting::KEY_WAREHOUSE_PRIORITY), true);
    }

    public function set(string $key, $value): void
    {
        $setting = Setting::query()->firstOrNew([
            'key' => $key,
        ]);

        $setting->value = $value;
        $setting->save();
    }

    public function get(string $key): string
    {
        return Setting::query()->where('key', $key)->firstOrFail()->value;
    }

    public function updateAll(array $settings): int
    {
        return Setting::query()->upsert($settings, ['key'], ['value']);
    }
    public function update(string $key, $value): void
    {
        Setting::updateOrCreate(
            ['key' => $key],
            ['value' => $value]
        );
    }
}
