<?php

namespace App\Repositories;

use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderShipment;
use Carbon\Carbon;

class PurchaseOrderShipmentRepository
{
    public function findOrCreate(PurchaseOrder $purchaseOrder, ?int $purchaseOrderShipmentId = null): PurchaseOrderShipment
    {
        return PurchaseOrderShipment::where('id', $purchaseOrderShipmentId)->firstOr(function () use ($purchaseOrder) {
            return PurchaseOrderShipment::create([
                'purchase_order_id' => $purchaseOrder->id,
                'shipment_date' => Carbon::now(),
                'fulfilled_shipping_method' => $purchaseOrder->shipping_method,
            ]);
        });
    }
}
