<?php

namespace App\Repositories;

use App\DTO\PurchaseOrderShipmentReceiptDto;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderShipmentReceipt;
use Carbon\Carbon;

class PurchaseOrderShipmentReceiptRepository
{
    public function save(PurchaseOrderShipmentReceiptDto $purchaseOrderShipmentReceiptDto): PurchaseOrderShipmentReceipt
    {
        $purchaseOrderShipmentReceipt = new PurchaseOrderShipmentReceipt($purchaseOrderShipmentReceiptDto->toArray());
        $purchaseOrderShipmentReceipt->save();

        return $purchaseOrderShipmentReceipt;
    }

    public function findForDate(PurchaseOrder $purchaseOrder, Carbon $date): ?PurchaseOrderShipmentReceipt
    {
        return PurchaseOrderShipmentReceipt::whereHas('purchaseOrderShipment', function ($query) use ($purchaseOrder) {
                $query->where('purchase_order_id', $purchaseOrder->id);
            })
            ->whereDate('received_at', $date)
            ->first();
    }

}
