<?php

namespace App\Repositories;

use App\Abstractions\AbstractRepository;
use App\Collections\ProductBrandCollection;
use App\Models\ProductBrand;

class ProductBrandRepository extends AbstractRepository
{
    public function __construct()
    {
    }

    public function getProductBrandByName(string $name): ?ProductBrand
    {
        return ProductBrand::whereName($name)->first();
    }

    public function saveBulk(ProductBrandCollection $data, bool $insert, bool $update): void
    {
        ProductBrand::dataFeedBulkImport([
            'data_to_import' => [
                'type' => 'json',
                'data' => $data->toJson(),
            ],
            'insert' => $insert,
            'update' => $update,
            'mappings' => [
                [
                    'expected_column_name' => 'name',
                    'data_column_name' => 'name',
                    'expected_column_type' => 'string',
                ],
            ],
            'default_columns' => [
                [
                    'expected_column_name' => 'created_at',
                    'default_value' => now(),
                    'expected_column_type' => 'datetime',
                ],
                [
                    'expected_column_name' => 'updated_at',
                    'default_value' => now(),
                    'expected_column_type' => 'datetime',
                ],
            ],
            'unique_by_columns' => [
                'name',
            ],
        ]);
    }
}
