<?php

namespace App\Repositories;

use App\Abstractions\AbstractRepository;
use App\Models\OrderLink;
use App\Models\PurchaseOrder;
use App\Models\SalesOrder;

class OrderLinkRepository extends AbstractRepository
{
    public function createDropshipOrderLink(SalesOrder $salesOrder, PurchaseOrder $purchaseOrder): void
    {
        OrderLink::create([
            'parent_type' => SalesOrder::class,
            'parent_id' => $salesOrder->id,
            'child_type' => PurchaseOrder::class,
            'child_id' => $purchaseOrder->id,
            'link_type' => OrderLink::LINK_TYPE_DROPSHIP,
        ]);
    }
}