<?php

namespace App\Repositories;

use App\Helpers;
use App\Models\IntegrationInstance;
use App\Models\NominalCode;
use App\Models\Setting;
use Illuminate\Database\Eloquent\Model;

class NominalCodeRepository
{
    public function getByCode(string $code): ?NominalCode
    {
        /** @var NominalCode $nominalCode */
        $nominalCode = NominalCode::query()
            ->where('code', $code)
            ->first();

        return $nominalCode ?? null;
    }

    public function getByName(string $name): ?NominalCode
    {
        /** @var NominalCode $nominalCode */
        $nominalCode = NominalCode::query()
            ->where('name', $name)
            ->first();

        return $nominalCode ?? null;
    }

    public function getCodeById(int $id): ?string
    {
        return NominalCode::query()->find($id)?->code;
    }

    public function getNominalCodeById(int $id): NominalCode
    {
        return NominalCode::findOrFail($id);
    }

    public function isAccountingNominalCodeMappingsSet(): bool
    {
        return
            ! is_null(Helpers::setting(Setting::KEY_NC_MAPPING_SALES_ORDERS)) &&
            ! is_null(Helpers::setting(Setting::KEY_NC_MAPPING_COGS)) &&
            ! is_null(Helpers::setting(Setting::KEY_NC_MAPPING_INVENTORY_CONTROL)) &&
            ! is_null(Helpers::setting(Setting::KEY_NC_MAPPING_ACCRUED_PURCHASES));
    }

    public function createMany(array $data): void
    {
        NominalCode::query()->upsert($data, 'code');
    }

    public function getCogsNominalCodeId(Model $event, ?IntegrationInstance $integrationInstance = null): int
    {
        // Prioritize specific, then work towards general

        // Product override
        if ($event->product?->cogs_nominal_code_id) {
            return $event->product->cogs_nominal_code_id;
        }

        $integrationSettings = @$integrationInstance?->integration_settings;
        if ($integrationSettings == '[]') {
            $integrationSettings = null;
        }

        // Integration override
        if ($integrationSettings && @$integrationSettings['cogs_nominal_code_id']) {
            return (int) $integrationSettings['cogs_nominal_code_id'];
        }

        // Default
        return (int) Helpers::setting(Setting::KEY_NC_MAPPING_COGS);
    }
}
