<?php

namespace App\Repositories;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Models\DataImportMapping;
use App\Models\IntegrationInstance;
use Illuminate\Support\Collection;

class DataImportMappingRepository
{
    /**
     * Store the mapping in database so that it can be later used for mappings.
     *
     * @throws \Illuminate\Database\Eloquent\InvalidCastException
     * @throws \Illuminate\Database\Eloquent\MissingAttributeException
     * @throws \LogicException
     */
    public function persistMapping(IntegrationInstance|IntegrationInstanceInterface $integrationInstance, string $mappingKey, array $mappings): void
    {
        if (! empty($mappings) && $integrationInstance) {
            DataImportMapping::setForModel($mappingKey, $mappings, [
                'integration_instance_id' => $integrationInstance->id,
            ]);
        }
    }

    public function getListingMappings(int $integrationInstanceId): Collection
    {
        return collect(
            DataImportMapping::query()
                ->where('model', 'listings')
                ->where('integration_instance_id', $integrationInstanceId)
                ->value('mapping')
        );
    }
}
