<?php

namespace App\Repositories;

use App\Abstractions\CustomFieldsInterface;
use App\Data\CustomFieldValueData;
use App\Models\CustomFieldValue;
use Illuminate\Support\Arr;

class CustomFieldValueRepository
{
    public function save(CustomFieldValueData $data): CustomFieldValue
    {
        return CustomFieldValue::updateOrCreate([
            'custom_field_id' => $data->custom_field_id,
            'link_id' => $data->link_id,
            'link_type' => $data->link_type,
        ], $data->toArray());
    }

    public function syncCustomFieldValues(CustomFieldsInterface $model, array $custom_field_values): void
    {
        foreach ($custom_field_values as $field_value) {
            $customFieldValueDto = CustomFieldValueData::from($field_value);
            // Check if the custom field value has an ID (existing value)
            if (isset($field_value['id'])) {
                // Update the existing custom field value
                CustomFieldValue::where('id', $customFieldValueDto->id)
                    ->where('link_id', $model->id)
                    ->update(['value' => $customFieldValueDto->value]);
            } else {
                $customFieldValueDto->link_id = $model->id;
                $customFieldValueDto->link_type = get_class($model);
                // Create a new custom field value
                CustomFieldValue::create($customFieldValueDto->toArray());
            }
        }
        // Delete any custom field values that were not included in the request
        CustomFieldValue::where('link_id', $model->id)
            ->where('link_type', get_class($model))
            ->whereNotIn('id', Arr::pluck($custom_field_values, 'id'))
            ->delete();
    }
}
