<?php

namespace App\Repositories;

use App\Abstractions\AbstractRepository;
use App\Data\AddressData;
use App\Helpers;
use App\Models\Address;
use Throwable;

class AddressRepository extends AbstractRepository
{
    /**
     * @throws Throwable
     */
    public function findOrCreate(AddressData $data): Address
    {
        $addressFillableData = new Address($data->toArray());

        $allowedColumns = [
            'name',
            'company',
            'email',
            'phone',
            'address1',
            'address2',
            'address3',
            'city',
            'province',
            'province_code',
            'zip',
            'country_code',
            'country',
        ];

        $matchingAddressQuery = Address::query();

        foreach ($data as $field => $value) {
            if (in_array($field, $allowedColumns)) {
                if (is_null($value)) {
                    $matchingAddressQuery->whereNull($field);
                } else {
                    $matchingAddressQuery->where($field, $value);
                }
            }
        }

        if ($matchingAddress = $matchingAddressQuery->first()) {
            return $matchingAddress;
        }

        $addressFillableData->save();

        return $addressFillableData;
    }
}
