<?php

namespace App\Queries;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class UpdateShopifyUnitCost
{
    public function execute($data, $integrationInstanceId)
    {
        if (! ($data)) {
            return;
        }

        $tmpTableName = 'tempShopifyInventoryUpdates_'.now()->timestamp.'_'.Str::random(5);

        $sql_temp_table = 'CREATE TEMPORARY TABLE '.$tmpTableName.' 
            (`id` bigint(20) unsigned, `unit_cost` decimal(12,4), PRIMARY KEY (`id`)) ENGINE=InnoDB;';

        $sql_insert = 'INSERT INTO '.$tmpTableName.' VALUES '.implode(',', $data).';';

        $sql_update = 'UPDATE shopify_products AS sp INNER JOIN '.$tmpTableName.' AS tiu 
            ON tiu.id = sp.inventory_item_id AND sp.integration_instance_id = '.$integrationInstanceId.' 
            SET sp.unit_cost = tiu.unit_cost';

        DB::statement($sql_temp_table);
        DB::statement($sql_insert);

        return DB::update($sql_update);
    }
}
