<?php

namespace App\Queries;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class UpdateShopifyListings
{
    public function execute($data, $salesChannelId)
    {
        if (! $data) {
            return;
        }

        // Create a temporary table to store the data
        $tmpTableName = 'tempShopifyListingUpdates_' . uniqid();

        // Drop the temporary table if it already exists
        DB::statement('DROP TEMPORARY TABLE IF EXISTS ' . $tmpTableName);

        // Create the temporary table
        $sql_temp_table = 'CREATE TEMPORARY TABLE '.$tmpTableName.'
            (`id` bigint(20) unsigned, `sku` varchar(255), `sales_channel_qty` int, `sales_channel_qty_last_updated` datetime, PRIMARY KEY (`id`)) ENGINE=InnoDB;';

        DB::statement($sql_temp_table);

        $data_chunks = array_chunk($data, 100);

        foreach ($data_chunks as $chunk) {
            $sql_insert = 'INSERT INTO '.$tmpTableName.' VALUES '.implode(',', $chunk).';';
            DB::statement($sql_insert);
        }

        $sql_update = 'UPDATE product_listings AS pl INNER JOIN '.$tmpTableName.' AS tlu
            ON tlu.id = pl.sales_channel_listing_id AND pl.sales_channel_id = '.$salesChannelId.'
            SET pl.listing_sku = tlu.sku, pl.sales_channel_qty = tlu.sales_channel_qty, pl.sales_channel_qty_last_updated = tlu.sales_channel_qty_last_updated, updated_at = "'.Carbon::now().'";';

        //Retry time on failure
        return retry(2, fn () => DB::update($sql_update), 1000);

        // return DB::update($sql_update); // returns update count
    }
}
