<?php

namespace App\Queries;

// use App\Lib\Inspect\Inspect;

use Illuminate\Support\Facades\DB;

class UpdateSalesChannelInventoryCache
{
    public function execute($data, $salesChannelId, $location_id)
    {
        if (! ($data)) {
            return;
        }
        DB::statement('DROP TEMPORARY TABLE IF EXISTS tempInventoryUpdates');
        $sql_temp_table = 'CREATE TEMPORARY TABLE tempInventoryUpdates 
            (`id` bigint(20) unsigned, `qty` bigint, last_updated datetime, PRIMARY KEY (`id`)) ENGINE=InnoDB;';

        $sql_insert = 'INSERT INTO tempInventoryUpdates VALUES '.implode(',', $data).';';

        $sql_update = 'UPDATE shopify_products AS sp INNER JOIN product_listings AS pl ON pl.document_id = sp.id AND pl.document_type = "App\\\Models\\\Shopify\\\ShopifyProduct" INNER JOIN tempInventoryUpdates AS tiu 
            ON tiu.id = sp.variant_id INNER JOIN sales_channels AS sc ON sc.integration_instance_id = sp.integration_instance_id AND sc.id = '.$salesChannelId.' 
           inner JOIN product_listing_inventory_locations AS plil ON plil.product_listing_id = pl.id AND plil.sales_channel_location_id = '.$location_id.'
            SET plil.sales_channel_qty = tiu.qty, pl.sales_channel_qty_last_updated = tiu.last_updated';

        DB::statement($sql_temp_table);
        DB::statement($sql_insert);

        return DB::update($sql_update);
    }
}
