<?php

namespace App\Queries;

use Illuminate\Support\Facades\DB;

// use App\Lib\Inspect\Inspect;

class ProductIdsByAttribute
{
    protected $attributeName = null;

    protected $attributeValue = null;

    public function __construct($attributeName, $attributeValue)
    {
        $this->attributeName = $attributeName;
        $this->attributeValue = $attributeValue;
        $this->tmpTableDynamicNamePrefix = 'tmp_'.md5(microtime().rand(0, 1000)).'_';
    }

    private function prepareTmpTableAttributes()
    {
        $query =
        "create temporary table {$this->tmpTableDynamicNamePrefix}attributes
         select * from `attributes`
         where
         `attributes`.`name` = ? ;";
        DB::select($query, [$this->attributeName]);
    }

    private function prepareTmpTableProductAttributes()
    {
        $query =
        "create temporary table {$this->tmpTableDynamicNamePrefix}product_attributes
         select * from `product_attributes` pa
         where
         pa.attribute_id IN (select id from {$this->tmpTableDynamicNamePrefix}attributes)
         and pa.`value` = CONVERT( ? USING utf8 ) ;";
        DB::select($query, [$this->attributeValue]);
    }

    public function get()
    {
        $this->prepareTmpTableAttributes();
        $this->prepareTmpTableProductAttributes();
        $query =
        "select pa.product_id from `{$this->tmpTableDynamicNamePrefix}attributes` a
        inner join `{$this->tmpTableDynamicNamePrefix}product_attributes` pa
        on a.`id` = pa.`attribute_id`
        where
        a.`name` = ?
        and pa.`value` = ? ;";

        return DB::select($query, [$this->attributeName, $this->attributeValue]);
    }
}
