<?php

namespace App\Providers;

use App\Events\CustomPurchaseInvoiceCreated;
use App\Events\GoodsReceived;
use App\Events\InventoryAdjusted;
use App\Events\JobProcessed;
use App\Events\PurchaseOrderLineDeleted;
use App\Listeners\LogInventoryReceivedActivity;
use App\Listeners\UpdateProductCost;
use App\Listeners\UpdatePurchaseOrderStatus;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Laravel\Horizon\Listeners\SendNotification;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        GoodsReceived::class => [
            LogInventoryReceivedActivity::class,
            UpdatePurchaseOrderStatus::class,
        ],
        CustomPurchaseInvoiceCreated::class => [
            UpdateProductCost::class,
        ],
        SalesChannelListingLinked::class => [
            SalesChannelListingLinkedAlert::class,
        ],

        JobProcessed::class => [
            SendNotification::class,
        ],

        InventoryBundlingCreated::class => [
            LogInventoryBundlingCreatedActivity::class,
        ],
        PurchaseOrderLineDeleted::class => [
            LogPurchaseOrderLineDeletedActivity::class,
        ],
        SalesOrderLineDeleted::class => [
            LogSalesOrderLineDeletedActivity::class,
        ],
        WarehouseTransferInitiated::class => [
            LogWarehouseTransferInitiatedActivity::class,
        ],
        WarehouseTransferReceived::class => [
            LogWarehouseTransferReceivedActivity::class,
        ],
//        InventoryAdjusted::class => [
//            LogInventoryAdjustedActivity::class,
//        ],
    ];

    /**
     * Register any events for your application.
     */
    public function boot(): void
    {
        //
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
